#include "General.h"
#include "TeamDonate.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

#define GREEN "104,234,40"

void PPage(int ID, const char* rgb_colour, const char *Format, ...)
{
	if(ID < 1 || ID > 128)
	{
		return;
	}

	if (!Get_GameObj(ID))
	{
		return;
	}

	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	float Version = Get_Client_Version(ID);

	if(Version < 2.9)
	{
		Console("ppage %d %s",ID, buffer);
                return;
	}
	else
	{
		Console("cmsgp %d %s %s", ID, rgb_colour, buffer);
	}
}

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);
	Console_Input(buffer);
}

int Get_Team_Player_Count_Working(int Team)
{
	int Total = 0;
	for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
	{
		cPlayer *p = PlayerIter->Data();

		if (p->IsActive)
		{
			int ID = p->PlayerId;
			if (Get_Team(ID) == Team)
			{
				Total++;
			}
		}
	}
	return Total;
}

TeamDonate::TeamDonate()
{
	RegisterEvent(EVENT_CHAT_HOOK,this);
}

TeamDonate::~TeamDonate()
{
	UnregisterEvent(EVENT_CHAT_HOOK,this);
}


bool TeamDonate::OnChat(int PlayerID,TextMessageEnum Type,const wchar_t *Message,int recieverID)
{
	if (Message[0] == L'!')
	{
		if ((wcsistr(Message,L"!teamdonate") == Message) || (wcsistr(Message,L"!tdonate") == Message)
			|| (wcsistr(Message,L"!td") == Message))
		{
			char throwaway[64]; 
			float Credits = 0;

			int ret = swscanf(Message, L"%s %f", throwaway, &Credits);
			if (ret == 2)
			{
			}
			else if (ret == 1)
			{
				Credits = Get_Money(PlayerID);
			}
			if (Credits > 0)
			{
				float PlayerMoney = Get_Money(PlayerID);
				if(PlayerMoney >= Credits)
				{
					int Team = Get_Team(PlayerID);
					int Count = Get_Team_Player_Count_Working(Team);
					if(Count > 1)
					{
						int DonateAmount = (int)Credits/(Count - 1);
						Commands->Give_Money(Get_GameObj(PlayerID),(Credits * -1),false);
						if (DonateAmount < 100)
						{
							PPage(PlayerID, GREEN, "Your team donation needs to be more than 100 credits per team member.");
						}
						else
						{
							for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
							{
								cPlayer *p = PlayerIter->Data();

								if (p->IsActive)
								{
									int ID = p->PlayerId;
									if ((Get_Team(ID) == Team) && (ID != PlayerID))
									{
										Commands->Give_Money(Get_GameObj(ID),(float)DonateAmount,false);
										PPage(ID, GREEN, "You have just been team donated %i credits by player %s.", DonateAmount, Get_Player_Name_By_ID(PlayerID));
									}
								}
							}
							PPage(PlayerID, GREEN, "You have donated %i credits to each member of your team.", DonateAmount);
						}
					}
					else
					{
						PPage(PlayerID, GREEN, "You can't team donate as you're the only player on your team.");
					}
				}
				else
				{
					PPage(PlayerID,GREEN, "You do not have %.0f credits, please lower your donation amount.", Credits);
				}
			}
			else
			{
				PPage(PlayerID,GREEN, "Donating negative credits isn't possible.");
			}
		return false;
		}
	}
	return true;
}

TeamDonate teamdonate;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &teamdonate;
}
